from pymol import cmd
from pymol import stored

def renewSel( name="site", sel="" ):
	"""
	Function: renewSel

	Purpose: When using PyMOL for molecular editing, we often change the structure
	of a molecule. This function will store your original definition of the molecule
	and then update it with that same definition, by residue, to include any new
	fragments you may have added.

	Usage: Use this function in place of select when making your original selection:
		renewSel caffeine, br. first resn CFF
	and if you modify the caffeine molecule you can renew it with,
		renewSel caffeine

	"""
	print "Name: %s" % name
	print "Sel : %s" % sel

	try:
		stored.selDict
	except AttributeError:
		stored.selDict = {}
	s = stored.selDict

	if sel=="":
		if name in s:
			sel = s[name]
		else:
			print "Selection %s not yet defined." % name
	else:
		s[name] = sel
		print "Updated dictionary."
		
	print "Making selection with name='%s' and sel='%s'" % (name,sel)
	cmd.select(name,sel)

cmd.extend("renewSel", renewSel)
