
#===================================================
# start clean

reinit

#===================================================
# create some empty selections for later use

select target, none
select inhibs, none
select prots, none
select solvs, none
select sites, none

#===================================================
# activate automatic grouping based on dot "." names

set group_auto_mode, 2

#===================================================
# load the first and template structure

load ../kinases/1oky.pdb, 1OKY.prt

# split off the inhibitor

create 1OKY.inh, 1OKY.prt and sto/
remove 1OKY.prt in 1OKY.inh
disable 1OKY.inh

# throw everything else into the solvent object

create 1OKY.sol, 1OKY.prt and not polymer
remove 1OKY.prt in 1OKY.sol
disable 1OKY.sol

# create hydrogen bonds

dist 1OKY.hbd, 1OKY.prt, 1OKY.inh, mode=2
disable 1OKY.hbd
color current, 1OKY.hbd

# accumulate selectons

select inhibs, 1OKY.inh or inhibs
select prots, 1OKY.prt or prots
select solvs, 1OKY.sol or solvs

set_title 1OKY.prt, 1, PDK1
set_title 1OKY.inh, 1, Staurosporine

#===================================================
# define the target for subsequent alignments

select target, prots////ca

# turn off automatic zooming
zoom
set auto.zoom, off

#===================================================
# load the next structure

load ../kinases/1z5m.pdb, 1Z5M.prt

# align it to the target

align 1Z5M.prt////CA, target

# split off the inhibitor

create 1Z5M.inh, 1Z5M.prt and 501/
remove 1Z5M.prt in 1Z5M.inh
disable 1Z5M.inh

# throw everything else into the solvent object

create 1Z5M.sol, 1Z5M and not polymer
remove 1Z5M.prt in 1Z5M.sol
disable 1Z5M.sol

# create hydrogen bonds

dist 1Z5M.hbd, 1Z5M.prt, 1Z5M.inh, mode=2
disable 1Z5M.hbd
color current, 1Z5M.hbd

# accumulate selectons

select inhibs, 1Z5M.inh or inhibs
select prots, 1Z5M.prt or prots
select solvs, 1Z5M.sol or solvs

set_title 1Z5M.prt, 1, PDK1

#===================================================
# load the next structure

load ../kinases/1t45.pdb, 1T45.prt

# align it to the target

align 1T45.prt////CA, target

create 1T45.sol, 1T45.prt and (solvent or inorganic)
remove 1T45.prt and (solvent or inorganic)
disable 1T45.sol

select prots, prots or 1T45.prt
select solvs, 1T45.sol or solvs

set_title 1T45.prt, 1, V-Kit

#===================================================
# load the next structure

load ../kinases/1t46.pdb, 1T46.prt

# align it to the target

align 1T46.prt////CA, target

# split off the inhibitor

create 1T46.inh, 1T46.prt and organic
remove 1T46.prt in 1T46.inh
disable 1T46.inh

# add positive charge to pick up H-bonds

alter 1T46.inh////N51, formal_charge=1

# throw everything else into the solvent object

create 1T46.sol, 1T46.prt and not polymer
remove 1T46.prt in 1T46.sol
disable 1T46.sol

# create hydrogen bonds

dist 1T46.hbd, 1T46.prt, 1T46.inh, mode=2
disable 1T46.hbd
color current, 1T46.hbd

# accumulate selectons

select inhibs, 1T46.inh or inhibs
select prots, 1T46.prt or prots
select solvs, 1T46.sol or solvs

set_title 1T46.prt, 1, V-Kit
set_title 1T46.inh, 1, Gleevec

#===================================================
# load the next structure

load ../kinases/1uwh.pdb, 1UWH.prt

# remove second copy

remove 1UWH.prt//B+Y//

# align it to the target

align 1UWH.prt////CA, target

# split off the inhibitor

create 1UWH.inh, 1UWH.prt and organic
remove 1UWH.prt in 1UWH.inh
disable 1UWH.inh

# throw everything else into the solvent object

create 1UWH.sol, 1UWH.prt and not polymer
remove 1UWH.prt in 1UWH.sol
disable 1UWH.sol

# create hydrogen bonds

dist 1UWH.hbd, 1UWH.prt, 1UWH.inh, mode=2
disable 1UWH.hbd
color current, 1UWH.hbd

# accumulate selectons

select inhibs, 1UWH.inh or inhibs
select prots, 1UWH.prt or prots
select solvs, 1UWH.sol or solvs

set_title 1UWH.prt, 1, B-Raf
set_title 1UWH.inh, 1, Bay493006

#===================================================
# load the next structure

load ../kinases/1pkg.pdb, 1PKG.prt

# align it to the target

align 1PKG.prt//A//ca, target 

# create substrate object

create 1PKG.sub, 1PKG.prt//B/567-569/
remove 1PKG.prt in 1PKG.sub
disable 1PKG.sub

# remove second kinase, ADP, MG

remove 1PKG.prt//B// or 1PKG.prt///1485-1486/ 

# create ADP object

create 1PKG.ADP, 1PKG.prt///1480/
remove 1PKG.prt in 1PKG.ADP
disable 1PKG.ADP

# create solvent object

create 1PKG.sol, 1PKG.prt and not polymer
remove 1PKG.prt in 1PKG.sol
disable 1PKG.sol

# draw hydrogen bonds

dist 1PKG.hbd, 1PKG.prt, 1PKG.ADP | 1PKG.sub, mode=2
dist 1PKG.hbd, 1PKG.sol, 1PKG.ADP, mode=2
disable 1PKG.hbd
color current, 1PKG.hbd

select inhibs, inhibs or 1PKG.ADP
select prots, prots or 1PKG.prt
select solvs, 1PKG.sol or solvs

set_title 1PKG.prt, 1, C-Kit

#===================================================
# adjust some of the settings

set stick_radius,0.2
set line_width, 2

set surface_color, white, (prots)
set surface_mode, 1, (inhibs)
set transparency, 0.5
set transparency, 0, (inhibs)

set two_sided_lighting, on

set ribbon_side_chain_helper, on

set seq_view, off, (inhibs | solvs | 1PKG.sub)

set stick_ball

#set valence

#===================================================
# create some additional useful selections

select sites, prots within 8 of inhib

#===================================================
# just display side chains near the active site

hide

show sticks, inhibs
show sticks, 1PKG.sub

show ribbon, prots
show dashes
hide labels

show lines, byres (prots within 6 of inhibs)
show nonbonded, (solvs within 6 of inhibs)
show sticks, byres (solvs within 6 of inhibs)

hide ribbon, (rep lines) and not ((not rep lines) extend 3)

# relative rotation

set_view (\
    -0.460319340,   -0.493266910,    0.738102436,\
     0.877761126,   -0.128493339,    0.461545944,\
    -0.132823855,    0.860337079,    0.492118806,\
    -0.000114247,   -0.000034653,  -90.687927246,\
    81.203063965,   19.396640778,   10.315279007,\
    75.063201904,  106.314315796,    0.000000000 )

disable
delete target

enable 1OKY*


set internal_gui_width, 280

refresh
save KinaseSession.pse

